<?php
/**
 * Pachyderm functions and definitions
 *
 * @package Sobe
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 *

 */
if ( ! isset( $content_width ) )
	$content_width = 600; /* pixels */

/**
 * Set a new content_width if using the wide page template
 */
function sobe_content_width() {
	global $content_width;

	if ( is_active_sidebar( 'sidebar-1' ) )
		$content_width = 500;
	
	if ( is_page_template( 'nosidebar-page.php' ) && is_active_sidebar( 'sidebar-1' ) )
		$content_width = 776;
}
add_action( 'template_redirect', 'sobe_content_width' );


if ( ! function_exists( 'sobe_setup' ) ):
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 *

 */
function sobe_setup() {

	/**
	 * Make theme available for translation
	 * Translations can be filed in the /languages/ directory
	 * If you're building a theme based on Pachyderm, use a find and replace
	 * to change 'sobe' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'sobe', get_template_directory() . '/languages' );

	/**
	 * Add default posts and comments RSS feed links to head
	 */
	add_theme_support( 'automatic-feed-links' );

	/**
	 * This theme uses wp_nav_menu() in one location.
	 */
	register_nav_menus( array(
		'primary'             => __( 'Primary Menu', 'sobe' ),
		'social-links'        => __( 'Sidebar Social Links', 'sobe' ),
		'footer-social-links' => __( 'Footer Social Links', 'sobe' ),
	) );

	/**
	 * Add support for Post Formats
	 */
	add_theme_support( 'post-formats', array( 'aside', 'image', 'video', 'quote', 'link', 'status', 'audio', 'chat', 'gallery' ) );

	/**
	* Add support for editor style
	*/
	add_editor_style();

	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );

	/*
	 * Enable support for Post Thumbnails for the Site Logo.
	 */
	add_theme_support( 'post-thumbnails' );

	add_image_size( 'sobe-logo', 800, 300 );

	/**
	 * Setup the WordPress core custom background feature.
	 */
	add_theme_support( 'custom-background', apply_filters( 'sobe_custom_background_args', array(
		'default-color' => 'fcf8f7',
	) ) );

	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'search-form', 'comment-form', 'comment-list', 'gallery', 'caption',
	) );

}
endif; // sobe_setup
add_action( 'after_setup_theme', 'sobe_setup' );

/**
 * Register widgetized area and update sidebar with default widgets
 *

 */
function sobe_widgets_init() {

	register_sidebar( array(
		'id' => 'sidebar-1',
		'name' => __( 'Sidebar' , 'sobe' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s clear">',
		'after_widget' => '</aside>',
		'before_title' => '<h1 class="widget-title">',
		'after_title' => '</h1>'
		)
	);

}
add_action( 'widgets_init', 'sobe_widgets_init' );

/**
 * Enqueue scripts and styles
 */
function sobe_scripts() {

	wp_enqueue_style( 'sobe-style', get_stylesheet_uri() );

	wp_enqueue_style( 'sobe-playfair', sobe_fonts_url() );
	
	wp_enqueue_style( 'sobe-post-formats', get_template_directory_uri() . '/fonts/postformats.css', array(), '0.4' );

	wp_enqueue_style( 'genericons', get_template_directory_uri() . '/fonts/genericons.css', array(), '3.3' );

	wp_enqueue_script( 'sobe-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20141207', true );

	wp_enqueue_script( 'sobe-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20141207', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

}
add_action( 'wp_enqueue_scripts', 'sobe_scripts' );


/**
 * Change excerpt [...] to a Continue Reading link
 **/

function sobe_new_excerpt_more( $more ) {
    global $post;
	return '...<a class="more-link" href="'. esc_url( get_permalink( $post->ID ) ) . '">' . __( 'Continue reading <span class="meta-nav">&raquo;</span>', 'sobe' ) . '</a>';
}
add_filter( 'excerpt_more', 'sobe_new_excerpt_more' );


/**
 * Register Google Fonts
 */
function sobe_fonts_url() {
    $fonts_url = '';
    
    /* Translators: If there are characters in your language that are not
	 * supported by Playfair Display, translate this to 'off'. Do not translate
	 * into your own language.
	 */
	$playfair = _x( 'on', 'Playfair Display font: on or off', 'sobe' );

	$lato = _x( 'on', 'Lato font: on or off', 'sobe' );

	if ( 'off' !== $playfair || 'off' !== $lato ) {

		$font_families = array();
	
		if ( 'off' !== $playfair ) {
			$font_families[] = 'Playfair Display:400,700,900,400italic,700italic,900italic';
		}

		if ( 'off' !== $lato ) {
			$font_families[] = 'Lato:300,300italic,400,400italic,700italic';
		}

		$query_args = array(
			'family' => urlencode( implode( '|', $font_families ) ),
			'subset' => urlencode( 'latin,latin-ext' ),
		);

		$fonts_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );

	}
	
	return $fonts_url;

}

/**
 * Enqueue Google Fonts for Editor Styles
 */
function sobe_editor_styles() {
    add_editor_style( array( 'editor-style.css', sobe_fonts_url() ) );
}
add_action( 'after_setup_theme', 'sobe_editor_styles' );

/**
 * Enqueue Google Fonts for custom headers
 */
function sobe_admin_scripts( $hook_suffix ) {

	wp_enqueue_style( 'sobe-playfair', sobe_fonts_url(), array(), null );

}
add_action( 'admin_print_styles-appearance_page_custom-header', 'sobe_admin_scripts' );

/**
 * Implement the Custom Header feature
 */
require( get_template_directory() . '/inc/custom-header.php' );

/*
 * Load Jetpack compatibility file.
 */
require( get_template_directory() . '/inc/jetpack.php' );

/**
 * Custom template tags for this theme.
 */
require( get_template_directory() . '/inc/template-tags.php' );

/**
 * Custom functions that act independently of the theme templates
 */
require( get_template_directory() . '/inc/extras.php' );

/**
 * Customizer additions
 */
require( get_template_directory() . '/inc/customizer.php' );

// updater for WordPress.com themes
if ( is_admin() )
	include dirname( __FILE__ ) . '/inc/updater.php';
