<?php
/**
 * @package Sobe
 */

/**
 * Setup the WordPress core custom header feature.
 *
 * @uses sobe_header_style()
 * @uses sobe_admin_header_style()
 * @uses sobe_admin_header_image()
 *
 * @package Sobe
 */
function sobe_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'sobe_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => '#e57667',
		'width'                  => 920,
		'height'                 => 300,
		'flex-height'            => true,
		'flex-width'			 => true,
		'wp-head-callback'       => 'sobe_header_style',
		'admin-head-callback'    => 'sobe_admin_header_style',
		'admin-preview-callback' => 'sobe_admin_header_image',
	) ) );
}
add_action( 'after_setup_theme', 'sobe_custom_header_setup' );

if ( ! function_exists( 'sobe_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see sobe_custom_header_setup().
 *

 */
function sobe_header_style() {

	$header_text_color = get_header_textcolor();
	// If no custom options for text are set, let's bail
	// get_header_textcolor() options: HEADER_TEXTCOLOR is default, hide text (returns 'blank') or any hex value
	if ( HEADER_TEXTCOLOR == $header_text_color ) {
		return;
	}
	// If we get this far, we have custom styles. Let's do this.
	?>
	<style type="text/css">
	<?php
		// Has the text been hidden?
		if ( 'blank' == $header_text_color ) :
	?>
		.site-title,
		.site-description {
			position: absolute;
			clip: rect(1px, 1px, 1px, 1px);
		}
	<?php
		// If the user has set a custom color for the text use that
		else :
	?>
		.site-title a {
			color: #<?php echo esc_attr( $header_text_color ); ?>;
		}
	<?php endif; ?>
	</style>
	<?php
}
endif; // sobe_header_style

if ( ! function_exists( 'sobe_admin_header_style' ) ) :
/**
 * Styles the header image displayed on the Appearance > Header admin panel.
 *
 * @see sobe_custom_header_setup().
 *

 */
function sobe_admin_header_style() {
?>
	<style type="text/css">
	.appearance_page_custom-header #headimg {
		border: none;
		font-size: 16px;
		text-align: center;
	}
	#headimg h1 {
		clear: both;
		font-family: "Playfair Display", Times, serif;
		font-size: 81px;
		font-weight: 900;
		line-height: 1;
		margin: 0 0 .1875em;
	}
	#headimg h1 a {
		text-decoration: none;
	}
	#desc {
		clear: both;
		color: #999594 !important;
		font-family: "Playfair Display", Times, serif;
		font-style: italic;
		font-size: 20px;
		font-weight: normal;
		margin: .25em 0 1.25em;
	}
	#headimg .custom-header {
		clear: both;
		display: block;
		max-width: 100%;
		height: auto;
		margin: 3em auto 1.5em;
		max-width: 100%;
		height: auto;
	}
	
	<?php if ( is_active_sidebar( 'sidebar-1' ) || has_nav_menu( 'social-links' ) ) { ?>
		#headimg {
			max-width: 920px;
		}
	<?php } else { ?>
		#headimg {
			max-width: 744px;
		}
	<?php } ?>
	</style>
<?php
}
endif; // sobe_admin_header_style

if ( ! function_exists( 'sobe_admin_header_image' ) ) :
/**
 * Custom header image markup displayed on the Appearance > Header admin panel.
 *
 * @see sobe_custom_header_setup().
 *

 */
function sobe_admin_header_image() {
	$style = sprintf( ' style="color:#%s;"', get_header_textcolor() );
?>
	<div id="headimg">
		<?php if ( get_header_image() ) : ?>
		<img src="<?php header_image(); ?>" alt="" class="custom-header">
		<?php endif; ?>
		<?php if ( function_exists( 'jetpack_the_site_logo' ) && jetpack_has_site_logo() ) { ?>
			<?php jetpack_the_site_logo(); ?>
		<?php } ?>
		<h1 class="displaying-header-text"><a id="name"<?php echo $style; ?> onclick="return false;" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a></h1>
		<div class="displaying-header-text" id="desc"<?php echo $style; ?>><?php bloginfo( 'description' ); ?></div>
	</div>
<?php }
endif; // sobe_admin_header_image