<?php
/**
 * Jetpack Compatibility File
 * See: http://jetpack.me/
 *
 * @package Sobe
 */

if ( ! function_exists( 'sobe_infinite_scroll_setup' ) ) {
	
	/**
	 * Add theme support for Infinite Scroll.
	 * See: http://jetpack.me/support/infinite-scroll/
	 */
	function sobe_infinite_scroll_setup() {
		add_theme_support( 'infinite-scroll', array(
			'container'      => 'main',
			'footer'         => 'page',
		) );

		add_theme_support( 'site-logo', array( 'size' => 'sobe-logo' ) );

		add_theme_support( 'jetpack-responsive-videos' );
	}
	add_action( 'after_setup_theme', 'sobe_infinite_scroll_setup' );

}

if ( ! function_exists( 'sobe_footer_widgets' ) ) {

	function sobe_footer_widgets() {
		if ( has_nav_menu( 'footer-social-links' ) )
			return true;

		return;
	}

}
add_filter( 'infinite_scroll_has_footer_widgets', 'sobe_footer_widgets' );